/*------------------------------------------------------------------------------*
 * File Name: ProgressBox														*
 * Creation: GRD, 2002.06.29													*
 * Purpose: OriginC Source C file for Tutorial									*
 * Copyright (c) OriginLab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <origin.h>
////////////////////////////////////////////////////////////////////////////////////

// Display a Progress Box
void Progress(int iBegin, int iEnd)
{
	int			iStep = 0;
	BOOL		bOK = 0;
	DWORD		dw1 = 0;
	DWORD		dw2 = 0;
	int			iDone = 0;
	int			iTemp;
	
	// Display the progress box
	progressBox pbox("Working...", 0);

	// Swap the arguments if the first is larger
	if(iBegin > iEnd)
	{
		iTemp = iBegin;
		iBegin = iEnd;
		iEnd = iTemp;
	}

	// Set the range
	pbox.SetRange(iBegin, iEnd);

	// Get the system tick count (in milliseconds)
	dw2 = GetTickCount();

	// Loop from the first number to the last
	for(iStep = iBegin; iStep <= iEnd; iStep++)
	{
		// Wait 1 second - This function is defined in this file
		WaitASec(1.0);
		// Set the progress indicator to the next value
		bOK = pbox.Set(iStep);
		// If the user pressed escape or clicked Cancel, then terminate the loop
		if(!bOK)
		{
			printf("Progress Box terminated by user.\n");
			return;
		}
	}
}

// Delay a specified number of seconds
void WaitASec(double dSeconds)
{
	DWORD	dw1;
	DWORD	dw2;
	int		iDone;

	dw1 = GetTickCount();
	dw2 = dw1;
	for(iDone = 0; iDone==0; )
	{
		if((dw2 - dw1) < dSeconds * 1000.0)
			dw2 = GetTickCount();
		else iDone = 1;
	}
}